/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dshuds.keyboard;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dshuds.Environment;
import org.orecruncher.dshuds.ModOptions;
import org.orecruncher.dshuds.hud.LightLevelHUD;
import org.orecruncher.lib.Localization;
import org.orecruncher.lib.compat.EntityRendererUtil;

@SideOnly(value=Side.CLIENT)
public class KeyHandler {
    private static final String SECTION_NAME = "Dynamic Surroundings: HUDs";
    private static KeyBinding SELECTIONBOX_KEY;
    private static KeyBinding LIGHTLEVEL_KEY;
    private static KeyBinding CHUNKBORDER_KEY;
    private static final String chatPrefix;

    public static void init() {
        SELECTIONBOX_KEY = new KeyBinding("dshuds.keybind.SelectionBox", 48, SECTION_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)SELECTIONBOX_KEY);
        LIGHTLEVEL_KEY = new KeyBinding("dshuds.keybind.LightLevel", 65, SECTION_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)LIGHTLEVEL_KEY);
        CHUNKBORDER_KEY = new KeyBinding("dshuds.keybind.ChunkBorders", 67, SECTION_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)CHUNKBORDER_KEY);
        MinecraftForge.EVENT_BUS.register(KeyHandler.class);
    }

    private static String getOnOff(boolean flag) {
        return Localization.format((String)(flag ? "dshuds.keybind.msg.ON" : "dshuds.keybind.msg.OFF"), (Object[])new Object[0]);
    }

    private static void sendPlayerMessage(String fmt, Object ... parms) {
        if (ModOptions.logging.hideChatNotices) {
            return;
        }
        EntityPlayer player = Environment.getPlayer();
        if (player != null) {
            String txt = chatPrefix + Localization.format((String)fmt, (Object[])parms);
            player.func_145747_a((ITextComponent)new TextComponentString(txt));
        }
    }

    private static boolean shouldHandle(@Nonnull KeyBinding binding) {
        return binding != null && binding.func_151468_f();
    }

    @SubscribeEvent(receiveCanceled=false)
    public static void onKeyboard(@Nonnull InputEvent.KeyInputEvent event) {
        if (KeyHandler.shouldHandle(SELECTIONBOX_KEY)) {
            EntityRenderer renderer = Minecraft.func_71410_x().field_71460_t;
            boolean result = !EntityRendererUtil.getDrawBlockOutline((EntityRenderer)renderer);
            EntityRendererUtil.setDrawBlockOutline((EntityRenderer)renderer, (boolean)result);
            KeyHandler.sendPlayerMessage("dshuds.keybind.msg.Fencing", KeyHandler.getOnOff(result));
        }
        if (KeyHandler.shouldHandle(CHUNKBORDER_KEY)) {
            boolean result = Minecraft.func_71410_x().field_184132_p.func_190075_b();
            KeyHandler.sendPlayerMessage("dshuds.keybind.msg.ChunkBorder", KeyHandler.getOnOff(result));
        }
        if (KeyHandler.shouldHandle(LIGHTLEVEL_KEY)) {
            if (GuiScreen.func_146271_m()) {
                if (LightLevelHUD.showHUD) {
                    ++ModOptions.lightLevelHUD.displayMode;
                    if (ModOptions.lightLevelHUD.displayMode >= LightLevelHUD.Mode.values().length) {
                        ModOptions.lightLevelHUD.displayMode = 0;
                    }
                    KeyHandler.sendPlayerMessage("dshuds.keybind.msg.LLDisplayMode", LightLevelHUD.Mode.getMode(ModOptions.lightLevelHUD.displayMode).name());
                }
            } else if (GuiScreen.func_146272_n()) {
                if (LightLevelHUD.showHUD) {
                    ModOptions.lightLevelHUD.hideSafe = !ModOptions.lightLevelHUD.hideSafe;
                    KeyHandler.sendPlayerMessage("dshuds.keybind.msg.LLSafeBlocks", KeyHandler.getOnOff(ModOptions.lightLevelHUD.hideSafe));
                }
            } else {
                LightLevelHUD.showHUD = !LightLevelHUD.showHUD;
                KeyHandler.sendPlayerMessage("dshuds.keybind.msg.LLDisplay", KeyHandler.getOnOff(LightLevelHUD.showHUD));
            }
        }
    }

    static {
        chatPrefix = TextFormatting.BLUE + "[" + TextFormatting.GREEN + SECTION_NAME + TextFormatting.BLUE + "] " + TextFormatting.RESET;
    }
}

